<?php

namespace Pepper\Money\Controller\Checkout;

use Magento\Framework\App\Action\Context;
use Magento\Framework\Serialize\Serializer\Json;
use Magento\Customer\Model\ResourceModel\Customer\CollectionFactory as CustomerFactory;
use Magento\Sales\Model\ResourceModel\Order\CollectionFactory as OrderFactory;
use Magento\Quote\Model\ResourceModel\Quote\CollectionFactory as QuoteFactory;
use Magento\Catalog\Model\ResourceModel\Product\CollectionFactory as ProductFactory;
use Magento\Catalog\Helper\Image as ImageHelper;
use Magento\Framework\Controller\Result\JsonFactory;

use Magento\Catalog\Model\ProductRepository;
use Magento\Checkout\Model\Cart;
use Magento\Checkout\Model\Session;
use Magento\Framework\Data\Form\FormKey;
use Magento\Framework\View\Result\PageFactory;
use Magento\Sales\Model\Order\Email\Sender\InvoiceSender;
use Magento\Sales\Model\Service\InvoiceService;
use Magento\Sales\Model\Order\Payment\Transaction;
use Magento\Store\Model\StoreManagerInterface;
use Magento\Quote\Api\CartManagementInterface;

use Pepper\Money\Controller\PepperController;
use Pepper\Money\lib\Pepper\Client;

class Cartdata extends \Magento\Framework\App\Action\Action
{
    protected $_jsonHelper;
    protected $_customerFactory;
    protected $_orderFactory;
    protected $_quoteFactory;
    protected $_jsonFactory;
    protected $_productFactory;
    protected $_imageHelper;
    protected $_PepperController;

    protected $currentOrderId;
    protected $currentCartId;

    public function __construct(
        Context $context,
        Json $jsonHelper,
        CustomerFactory $customerFactory,
        OrderFactory $orderFactory,
        QuoteFactory $quoteFactory,
        JsonFactory $jsonFactory,
        ProductFactory $productFactory,
		ImageHelper $imageHelper,
		PepperController $PepperController
    )
    {
        $this->_jsonHelper = $jsonHelper;
        $this->_customerFactory = $customerFactory;
        $this->_orderFactory = $orderFactory;
        $this->_quoteFactory = $quoteFactory;
        $this->_jsonFactory = $jsonFactory;
        $this->_productFactory = $productFactory;
        $this->_imageHelper = $imageHelper;
    	$this->_PepperController = $PepperController;

        parent::__construct($context);
    }

    public function execute()
    {
		header('Content-type:application/json;charset=utf-8');
        $result = $this->_jsonFactory->create();
		$pepper_client = $this->_PepperController->getPepperClient();

        $request = (array)json_decode(file_get_contents('php://input'));
        if ($request == null) {
            http_response_code(400);
            $result->setData(['error' => 'Missing request parameters']);
            return $result;
        }

        $signature = $request['signature'];        
        $this->currentCartId = $request['cart_id'];

        if ($this->currentCartId == null) {
            http_response_code(400);
            $result->setData(['error' => 'Missing request parameters']);
            return $result;
        }

        if (!$pepper_client->checkCartDataSignature($request, $signature)) {
            http_response_code(401);
            $result->setData(['error' => 'Wrong signature']);
            return $result;
        }
        
        $objectManager = \Magento\Framework\App\ObjectManager::getInstance();
        $quote = $objectManager->create('\Magento\Quote\Model\Quote')->load($this->currentCartId);
        if (!$quote && !is_object($quote) || $quote->getId() === null) {
            http_response_code(404);
            $result->setData(['error' => sprintf('Unable to load cart by card id "%d".', $this->currentCartId)]);
            return $result;
        }

        $order = $objectManager->create('\Magento\Sales\Model\Order')->load($quote->getReservedOrderId(), 'increment_id');
        if ( !$order && !is_object($order) || $order->getId() === null ) {
            http_response_code(400);
            return ['error' => 'Cart paid'];
        }

        $json = $pepper_client->getCartData(
            $quote,
            false, 
            null,
			$this->get_baseURL()
        );
        
        $result->setData($json);
        return $result;
    }
	
}
