<?php

namespace Pepper\Money\Controller\Checkout;

use Magento\Catalog\Model\ProductRepository;
use Magento\Checkout\Model\Cart;
use Magento\Checkout\Model\Session;
use Magento\Framework\App\Action\Context;
use Magento\Framework\Data\Form\FormKey;
use Magento\Framework\View\Result\PageFactory;
use Magento\Sales\Model\Order\Email\Sender\InvoiceSender;
use Magento\Sales\Model\Service\InvoiceService;
use Magento\Sales\Model\Order\Payment\Transaction;
use Magento\Store\Model\StoreManagerInterface;
use Magento\Quote\Api\CartManagementInterface;

use Pepper\Money\Controller\PepperController;
use Pepper\Money\lib\Pepper\Client;

class Notify extends \Magento\Framework\App\Action\Action
{
    protected $_resultPageFactory;
    protected $_PepperController;
    protected $_session;
    protected $_invoiceService;
    protected $_invoiceSender;
    protected $_cart;
    protected $_formKey;
    protected $_productRepository;
	protected $_quoteManagement;

    public function __construct(Context $context, Session $session, PageFactory $resultPageFactory, StoreManagerInterface $storeManager, PepperController $PepperController, InvoiceService $invoiceService, InvoiceSender $invoiceSender, Cart $cart, ProductRepository $productRepository, FormKey $formKey, CartManagementInterface $quoteManagement)
    {
    	$this->_session = $session;
    	$this->_invoiceSender = $invoiceSender;
    	$this->_invoiceService = $invoiceService;
    	$this->_PepperController = $PepperController;
    	$this->_resultPageFactory = $resultPageFactory;
    	$this->_cart = $cart;
    	$this->_formKey = $formKey;
    	$this->_productRepository = $productRepository;
		$this->_quoteManagement = $quoteManagement;
    	parent::__construct($context);
	}
    
    public function execute()
    {
		header('Content-type:application/json;charset=utf-8');
    	$resultPage = $this->_resultPageFactory->create();
		$resultPage->getLayout()->initMessages();

		$pepper_client = $this->_PepperController->getPepperClient();

		$data = (array)json_decode(file_get_contents('php://input'));
		$status = $data['result'];
		$cart_id = $data['cart_id'];
		$order = $data['order'];
		$pepper_order_id = $order->order_id;
		$total_price = $order->total_price;
		$signature = $data['signature'];

		$url = array(
			'cancel' => $this->_PepperController->get_baseURL()."checkout"
		);

		if ($status && $cart_id && $pepper_order_id) {
		} else {
			http_response_code(400);
			$result = array();
			$result['result'] = 'failure';
			$result['message'] = 'Params result, cart_id, order are required';
			$result['redirect_url'] = $url['cancel'];
			die(json_encode($result));
		}
		if (!$pepper_client->checkSignature($data, $signature)) {
			http_response_code(401);
			$result = array();
			$result['result'] = 'failure';
			$result['message'] = 'Wrong signature';
			$result['redirect_url'] = $url['cancel'];
			die(json_encode($result));
		}

		$redirect_url = $url['cancel'];
		$message = '';
		$result = 'failure';

		try {
			$objectManager = \Magento\Framework\App\ObjectManager::getInstance();
			$quote = $objectManager->create('\Magento\Quote\Model\Quote')->load($cart_id);
			if (!$quote && !is_object($quote) || $quote->getId() === null) {
				http_response_code(404);
				$message = sprintf('Unable to load cart by cart id "%d".', $cart_id);
				$result = array();
				$result['result'] = 'failure';
				$result['message'] = $message;
				$result['redirect_url'] = $url['cancel'];
				die(json_encode($result));
			}

			if ($total_price != null && $total_price != $quote->getGrandTotal()) {
				$result = array();
				$result['result'] = 'FRAUD';
				$result['message'] = 'Price not equal, current price = ' . $quote->getGrandTotal() . ' and price from cart = ' . $total_price;
				$result['redirect_url'] = $url['cancel'];
				die(json_encode($result));
			}

			switch ($status) {
				case $status == 'OPE':	
					try
					{
						if (!$quote->getIsActive()) {
							$result = 'DUPLICATED';
							$message = 'Status for order id = ' . $pepper_order_id . ' and cart id = ' . $cart_id . ' is already ' . $status . ' (request ignored)';
						}
						else
						{
							$order = $this->_quoteManagement->submit($quote);
							$this->_session->setLastOrderId($order->getId())->setLastRealOrderId($order->getIncrementId());
							$this->confirmOrder($order, $pepper_order_id);
							$redirect_url = $this->_PepperController->get_baseURL()."pepper/checkout/success/".'?quote_id='.$quote->getId();
							$result = 'success';
							$message = 'Successfully updated status from order with order id = ' . $pepper_order_id . ' and cart id = ' . $cart_id . ' to ' . $status;
						}
					} catch (Exception $e) {
						$message = 'Magento error: ' . $e->getMessage();
					}
					break;
				case $status == 'CAN':
					$result = 'success';
					$message = 'Status ignored';
					break;
				case $status == 'EXP':
					$result = 'success';
					$message = 'Status ignored';
					break;
				case $status == 'REJ':
					$result = 'success';
					$message = 'Status ignored';
					break;
				case $status == 'PEN':
					$result = 'success';
					$message = 'Your order will be processed when the payment is finished';
					break;
			}    
		} catch (Exception $e) {
			$message = 'Magento error: ' . $e->getMessage();
		}

		$result = [
			'result' => $result,
			'message' => $message,
			'redirect_url' => $redirect_url
		];
		die(json_encode($result));
    }

	private function confirmOrder($order, $pepper_order_id){
		try {			
			$invoice = $this->_invoiceService->prepareInvoice($order);
			$invoice->register();
			$invoice->pay();
			$invoice->setTransactionId($pepper_order_id);
			$invoice->save();

			$payment = $order->getPayment();
			$payment->setLastTransId($pepper_order_id);
			$payment->setTransactionId($pepper_order_id);
			$payment->setParentTransactionId($payment->getTransactionId());
			$transaction = $payment->addTransaction(Transaction::TYPE_CAPTURE, null, true, "");
			$payment->save();
			$transaction->save();

			if(!@$this->_invoiceSender->send($invoice)) {
				$order->addStatusHistoryComment(__("Pepper, fallo al enviar la factura."), false);
			}
			$order->addStatusHistoryComment(__("Pepper, factura generada."), false)->save();
			
			$status = $this->_PepperController->get_status();
    		$order->setState('new')->setStatus($status)->save();
    		$order->addStatusHistoryComment(__("Pepper, pago exitoso."), false)
	    		->setIsCustomerNotified(false)
				->save();
		} catch (Exception $e) {
			$order->addStatusHistoryComment('Pepper: Exception: '.$e->getMessage(), false);
			$order->save();
		}
	}
	
}
