<?php


namespace Pepper\Money\Controller\Checkout;

use Magento\Framework\App\Action\Context;
use Magento\Framework\View\Result\PageFactory;
use Magento\Checkout\Model\Session;
use Magento\Store\Model\StoreManagerInterface; 
use Pepper\Money\Controller\PepperController;

class Redirect extends \Magento\Framework\App\Action\Action
{
  	protected $_session;
  	protected $_resultPageFactory;
  	protected $_storeManager;
  	protected $_PepperController;

    public function __construct(Context $context, PageFactory $resultPageFactory, Session $session, StoreManagerInterface $storeManager, PepperController $PepperController){
	    $this->_session = $session;
	    $this->_resultPageFactory = $resultPageFactory;
    	$this->_storeManager = $storeManager;
    	$this->_PepperController = $PepperController;
    	
	    return parent::__construct($context);
    }
    
    public function execute()
    {
		$quote = $this->_session->getQuote();
		$quote_id = $quote->getId();
    	$not_processing=(!$this->_session->getData("Pepper".$quote_id) || $this->_session->getData("Pepper".$quote_id) < 10); 

		if (!$quote->getCustomerId()) {
			$quote->setCustomerIsGuest(1);
			$quote->setCustomerEmail($quote->getBillingAddress()->getEmail());
			$quote->save();
		} 	
    	
    	if($quote_id && $not_processing){ 
			$quote_items = $quote->getAllItems();
			$amount = floatval($quote->getGrandTotal());
			$client = array(
				"name" => $quote->getCustomerFirstname()." ".$quote->getCustomerLastname(),
				"email" => $quote->getCustomerEmail()
			);

	    	$try = $this->_session->getData("Pepper".$quote_id);
	    	
	    	if($try == null) {
				$try = 0;
			}

    		$try++;    		
    			
	    	$this->_session->setData("Pepper".$quote_id, $try);

			$resultPage = $this->_resultPageFactory->create();
			$resultPage->getConfig()->getTitle()->prepend(__("Redireccionando..."));
    		$resultPage->getLayout()->initMessages();
    		$resultPage->getLayout()->getBlock('pepper_checkout_redirect')->setTry($try);
    		
    		if($try < 10){    			    	
    			$quote_id = str_pad($quote_id.$try, 12, "0", STR_PAD_LEFT);
					    	
				$redirect_url = $this->_PepperController->getRedirectUrl($quote_id, $quote, $amount);
	    		$resultPage->getLayout()->getBlock('pepper_checkout_redirect');
    		}
    		
    		return $resultPage;
    	
    	} else {
			$this->_redirect("checkout");
		}
    }
    
}
