<?php


namespace Pepper\Money\Controller\Checkout;

use Magento\Framework\App\Action\Context;
use Magento\Framework\View\Result\PageFactory;
use Magento\Checkout\Model\Session;
use Magento\Store\Model\StoreManagerInterface; 
use Pepper\Money\Controller\PepperController;

class Success extends \Magento\Framework\App\Action\Action
{
  	protected $_session;
  	protected $_resultPageFactory;
  	protected $_storeManager;
	protected $_PepperController;

    public function __construct(Context $context, PageFactory $resultPageFactory, Session $session, StoreManagerInterface $storeManager, PepperController $PepperController){
	    $this->_session = $session;
	    $this->_resultPageFactory = $resultPageFactory;
    	$this->_storeManager = $storeManager;
    	$this->_PepperController = $PepperController;
    	
	    return parent::__construct($context);
    }
    
    public function execute()
    {
		$objectManager = \Magento\Framework\App\ObjectManager::getInstance();
		$quote = $objectManager->create('\Magento\Quote\Model\Quote')->load($_GET['quote_id']);
		$order = $objectManager->create('\Magento\Sales\Model\Order')->load($quote->getReservedOrderId(), 'increment_id');
		$this->_session->setLastSuccessQuoteId($quote->getId());
		$this->_session->setLastQuoteId($quote->getId());
		$this->_session->setLastOrderId($order->getId());
		$this->_session->setLastRealOrderId($order->getIncrementId());
		$this->_redirect("checkout/onepage/success/");
    }
    
}
