<?php
namespace Pepper\Money\Controller;

use Pepper\Money\Model\PepperModel;
use Magento\Store\Model\StoreManagerInterface;
use Pepper\Money\lib\Pepper\Client;

class PepperController extends \Magento\Framework\App\Action\Action
{
	protected $_baseURL;
    protected $_enabled;
    protected $_api;
    protected $_apikey;
    protected $_key;
    protected $_secret;
    protected $_environment;
    protected $_integration;
    protected $_title;
    protected $_description;
    protected $_status;
    protected $_width;
	protected $_enabled_n;
	protected $_title_n;
    protected $_description_n;

    public function __construct(PepperModel $model, StoreManagerInterface $storeManager) {
    	$this->_baseURL = $storeManager->getStore()->getBaseUrl();

		$integration = 'DEFAULT';
		if ($model->getConfigData('integration') == '1') {
			$integration = 'IFRAME';
		}
		$environment = 'TST';
		if ($model->getConfigData('environment') == '1') {
			$environment = 'PRO';
		}
		$enabled_n = 'no';
		if ($model->getConfigData('enabled_n') == '1') {
			$enabled_n = 'yes';
		}

    	$this->_enabled = $model->getConfigData('enabled');
    	$this->_api = $model->getConfigData('api');
    	$this->_apikey = $model->getConfigData('apikey');
    	$this->_key = $model->getConfigData('key');
    	$this->_secret = $model->getConfigData('secret');
    	$this->_environment = $environment;
    	$this->_integration = $integration;
    	$this->_title = $model->getConfigData('title');
    	$this->_description = $model->getConfigData('description');
    	$this->_status = $model->getConfigData('status');
    	$this->_width = $model->getConfigData('width');
    	$this->_enabled_n = $enabled_n;
    	$this->_title_n = $model->getConfigData('title_n');
    	$this->_description_n = $model->getConfigData('description_n');
    }

	/**
	 * _enabled
	 * @return unkown
	 */
	public function get_enabled(){
		return $this->_enabled;
	}

	/**
	 * _api
	 * @return unkown
	 */
	public function get_api(){
		return $this->_api;
	}

	/**
	 * _apikey
	 * @return unkown
	 */
	public function get_apikey(){
		return $this->_apikey;
	}

	/**
	 * _key
	 * @return unkown
	 */
	public function get_key(){
		return $this->_key;
	}

	/**
	 * _secret
	 * @return unkown
	 */
	public function get_secret(){
		return $this->_secret;
	}

	/**
	 * _environment
	 * @return unkown
	 */
	public function get_environment(){
		return $this->_environment;
	}

	/**
	 * _integration
	 * @return unkown
	 */
	public function get_integration(){
		return $this->_integration;
	}

	/**
	 * _title
	 * @return unkown
	 */
	public function get_title(){
		return $this->_title;
	}

	/**
	 * _description
	 * @return unkown
	 */
	public function get_description(){
		return $this->_description;
	}

	/**
	 * _status
	 * @return unkown
	 */
	public function get_status(){
		return $this->_status;
	}

	/**
	 * _width
	 * @return unkown
	 */
	public function get_width(){
		return $this->_width;
	}

	/**
	 * _title_n
	 * @return unkown
	 */
	public function get_enabled_n(){
		return $this->_enabled_n;
	}

	/**
	 * _title_n
	 * @return unkown
	 */
	public function get_title_n(){
		return $this->_title_n;
	}

	/**
	 * _description_n
	 * @return unkown
	 */
	public function get_description_n(){
		return $this->_description_n;
	}

	/**
	 * _baseURL
	 * @return unkown
	 */
	public function get_baseURL(){
		return $this->_baseURL;
	}

	public function get_storeLanguage(){
		/** @var \Magento\Framework\ObjectManagerInterface $om */
		$om = \Magento\Framework\App\ObjectManager::getInstance();
		/** @var \Magento\Framework\Locale\Resolver $resolver */
		$resolver = $om->get('Magento\Framework\Locale\Resolver');
		return $resolver->getLocale();
	}

	public function get_client_config() {
		return array(
			'api' => $this->get_api(),
			'apikey' => $this->get_apikey(),
			'key' => $this->get_key(),
			'secret' => $this->get_secret(),
			'environment' => $this->get_environment(),
			'integration' => $this->get_integration(),
			'title' => $this->get_title(),
			'description' => $this->get_description(),
			'width' => $this->get_width(),
			'enabled_n' => $this->get_enabled_n(),
			'title_n' => $this->get_title_n(),
			'description_n' => $this->get_description_n(),
		);
	}

	function process_regular_payment($pepper_client, $quote_id, $quote, $amount) {
		$json = $pepper_client->getCartData(
            $quote,
            true, 
            $this->get_integration(),
			$this->get_baseURL(),
			array_key_exists('n', $_GET) ? ($_GET['n'] == 'yes' ? 'DVN' : 'STD') : 'STD'
        );

        echo $pepper_client->getForm($json);

        return;
	}
	
	public function getPepperClient() {
		$config = $this->get_client_config();

		return new Client($config['key'], $config['secret'], $config['api']);
	}
	
	public function getRedirectUrl($quote_id, $quote, $amount){
		$url = $this->_baseURL."pepper/checkout/success/";

		$pepper_client = $this->getPepperClient();

		return $this->process_regular_payment( $pepper_client, strval($quote_id), $quote, $amount );
	}
    
    public function execute()
    {
    	die(0);
    }

}
