<?php

namespace Pepper\Money\Model;

class CsrfValidatorSkip
{
    /**
     * @param \Magento\Framework\App\Request\CsrfValidator $subject
     * @param \Closure $proceed
     * @param \Magento\Framework\App\RequestInterface $request
     * @param \Magento\Framework\App\ActionInterface $action
     */
    public function aroundValidate(
        $subject,
        \Closure $proceed,
        $request,
        $action
    ) {
        if ($request->getModuleName() == 'pepper' && 
            ($request->getFullActionName() == 'pepper_checkout_data' || $request->getFullActionName() == 'pepper_checkout_notify' || $request->getFullActionName() == 'pepper_checkout_cartdata')) {
            return; // Skip CSRF check
        }
        $proceed($request, $action); // Proceed Magento 2 core functionalities
    }
}