<?php

namespace Pepper\Money\Model;

use Magento\Checkout\Model\ConfigProviderInterface;

use Pepper\Money\Model\PepperModel;


class PepperConfigProvider implements \Magento\Checkout\Model\ConfigProviderInterface
{

    /**
     * Protected $model
     */
    protected $model;
    protected $layoutFactory;

    public function __construct(PepperModel $model, \Magento\Framework\View\LayoutFactory $layoutFactory) {
        $this->model = $model;
        $this->layoutFactory = $layoutFactory;
    }

    public function getConfig()
    {
        $conf = [
            'payment' => [
                'pepper' => [
                    'title' => $this->model->getTitle(),
                    'description' => $this->model->getDescription(),
                    'width' => $this->model->getWidth(),
                    'image' => $this->layoutFactory->create()->createBlock('Pepper\Money\Block\Notify')->getViewFileUrl('Pepper_Money/images/pepper.svg'),
                    'iframe' => $this->model->getIntegration() == 'IFRAME'
                ]
            ]
        ];
        //Checks divide n is enabled
        if ($this->model->getEnabledN() === 'yes') {
            $conf['payment']['pepper_n'] = [
                'title' => $this->model->getTitleN(),
                'description' => $this->model->getDescriptionN(),
                'width' => $this->model->getWidth(),
                'image' => $this->layoutFactory->create()->createBlock('Pepper\Money\Block\Notify')->getViewFileUrl('Pepper_Money/images/pepper.svg'),
                'iframe' => $this->model->getIntegration() == 'IFRAME'
            ];
        }

        return $conf;
    }
}
