<?php

namespace Pepper\Money\Model;

use Pepper\Money\Controller\PepperController;
use Pepper\Money\lib\Pepper\Client;


/**
 * Gateway payment method model
 */
class PepperModel extends \Magento\Payment\Model\Method\AbstractMethod
{

    /**
     * Payment code
     *
     * @var string
     */
    protected $_code = 'pepper';

    /**
     * Availability option
     *
     * @var bool
     */
    protected $_isOffline = false;
    
    protected $_isGateway = true;

    protected $_canRefund = false;
    protected $_canRefundInvoicePartial = false;
    protected $_resultPageFactory;

    protected $_PepperController;

    public function setController(PepperController $PepperController)
    {
    	$this->_PepperController = $PepperController;
    }
    
    public function getConfigData($field, $storeId=null){
    	return parent::getConfigData($field, $storeId);
    }

	public function getClientConfig() {
		$integration = 'DEFAULT';
		if ($this->getConfigData('integration') == '1') {
			$integration = 'IFRAME';
		}
		$environment = 'TST';
		if ($this->getConfigData('environment') == '1') {
			$environment = 'PRO';
		}
		$enabled_n = 'no';
		if ($this->getConfigData('enabled_n') == '1') {
			$enabled_n = 'yes';
		}
		$active_widget = 'no';
		if ($this->getConfigData('active_widget') == '1') {
			$active_widget = 'yes';
		}

		return array(
			'api' => $this->getConfigData('api'),
			'apikey' => $this->getConfigData('apikey'),
			'key' => $this->getConfigData('key'),
			'secret' => $this->getConfigData('secret'),
			'environment' => $environment,
			'integration' => $integration,
			'title' => $this->getConfigData('title'),
			'description' => $this->getConfigData('description'),
			'width' => $this->getConfigData('width'),
			'enabled_n' => $enabled_n,
			'active_widget' => $active_widget,
			'title_n' => $this->getConfigData('title_n'),
			'description_n' => $this->getConfigData('description_n'),
		);
	}

    function getApi(){
    	return __($this->getConfigData('api'));
    }

    function getApiKey(){
    	return __($this->getConfigData('apikey'));
    }

    function getEnvironment(){
    	return __($this->getClientConfig()['environment']);
    }

    function getIntegration(){
    	return __($this->getClientConfig()['integration']);
    }

    function getKey(){
    	return __($this->getConfigData('key'));
    }

    function getTitle(){
    	return __($this->getConfigData('title'));
    }

    function getDescription(){
    	return __($this->getConfigData('description'));
    }

    function getWidth(){
        return $this->getConfigData('width');
    }


    function getEnabledN(){
    	return $this->getClientConfig()['enabled_n'];
    }

    function getActiveWidget(){
    	return $this->getClientConfig()['active_widget'];
    }

    function getTitleN(){
    	return __($this->getConfigData('title_n'));
    }

    function getDescriptionN(){
    	return __($this->getConfigData('description_n'));
    }
}
