<?php

namespace Pepper\Money\lib\Pepper;

class Client
{
    public $apiUrl = 'https://api-ecommerce.peppermoney.es/v1/';
    private $publicKey = 'test';
    private $secretKey = 'test';

    public function __construct($publicKey, $secretKey, $apiUrl)
    {
        $this->publicKey = $publicKey;
        $this->secretKey = $secretKey;
        $this->apiUrl = $apiUrl;
        return $this;
    }

    public function getPlaceOrderPath($path = '')
    {
        return $this->apiUrl.'place-order/';
    }

    public function getForm($json_dict)
    {
        $html = '<form id="pepper-form" action="'.$this->getPlaceOrderPath().'" method="post">'.$this->getFields($json_dict).'</form>'.'<script>document.getElementById("pepper-form").submit();</script>';
        return trim($html);
    }

    public function getFields($json_dict)
    {
        $json_dict_encoded = base64_encode(json_encode($json_dict));
        $signature = $this->getSignature($json_dict);

        $html = '';
        $html .= "\n".'<input type="hidden" name="params" value="'.$json_dict_encoded.'" />';
        $html .= "\n".'<input type="hidden" name="signature" value="'.$signature.'" />';

        return trim($html);
    }

    public function getSignature($json_dict)
    {
        $key = $json_dict['platform'].$json_dict['order_date'].$json_dict['transaction_id'].$json_dict['total_price'].$this->secretKey;
        return hash('sha256', $key);
    }

    public function checkSignature($json_dict, $signature)
    {
        $key = $json_dict['result'].$json_dict['cart_id'].$this->secretKey;
        return hash('sha256', $key) == $signature;
    }

    public function checkMacroDataSignature($json_dict, $signature)
    {
        $key = 'PEN'.$json_dict['cart_id'].$this->secretKey;
        return hash('sha256', $key) == $signature;
    }

    public function checkCartDataSignature($json_dict, $signature)
    {
        $key = 'NEW'.$json_dict['cart_id'].$this->secretKey;
        return hash('sha256', $key) == $signature;
    }

    public function getRandomNumber()
    {
        # To generate random number
        srand(time());
        return rand(10, 99);
    }

    public function removeRandomNumber($value)
    {
        return substr($value, 0, -2);
    }

    public function getCartData($quote, $addCartUrl, $viewMode, $baseURL, $product_type) {
        $objectManager = \Magento\Framework\App\ObjectManager::getInstance();
	$billing_address = $quote->getBillingAddress();
	$shipping_address = $quote->getShippingAddress();
	$email = $quote->getCustomerEmail();
	$customer = $quote->getCustomer();

        $products = array();
        $total_products = 0;			
        //Fill Products
        foreach ($quote->getItemsCollection() as $item) {
            //Don't include Configurable product
            if ($item->getParentItem()) continue;
            $attributes = '';
            $options = $item->getProduct()->getTypeInstance(true)->getOrderOptions($item->getProduct());

            if (isset($options['attributes_info'])) {
                foreach ($options['attributes_info'] as $attribute) {
                    $attributes .= $attribute['label'] . ':' . $attribute['value'] . '-';
                }
                $attributes = rtrim($attributes, '-');
            }

            $total_products += (int)$item->getQty();

            $products[] = array(
                'id' => (int)$item->getProductId().'',
                'reference' => $item->getSku().'',
                'name' => $item->getName(),
                'qty' => (int)$item->getQty(),
                'price' => (float)$item->getPrice(),
                'attributes' => $attributes
            );
        }

	$data = json_decode('{"term":0,"externalData":"N/A","transactionId":"N/A", "term_dvn":0}');
        if ( isset($_COOKIE['send_pepper_info']) ) {
            $data = json_decode($_COOKIE['send_pepper_info']);
        }

        $phone1 = $billing_address->getTelephone();
        $phone2 = $shipping_address->getTelephone();
        if (strlen($phone1) < 9) {
            $phone1 = '';
        }
        if (strlen($phone2) < 9) {
            $phone2 = '';
        }

    //check shipping address (if any field is empty returns null).
    $shipping_address_data = $this->check_shipping_address(
        $shipping_address->getCountry(), 
        $shipping_address->getCity(), 
        $shipping_address->getRegion(), 
        $shipping_address->getPostcode(), 
        $shipping_address->getStreetFull(), 
        $phone2
    );
		
	$json = array(
            'platform' => 'MAG2',
            'order_date' => date('Y-m-d'),
            'transaction_id' => $data->transactionId,
            'term' => intval($data->term),
            'term_dvn' => intval($data->term_dvn),
            'total_products' => $total_products,
            'total_price' => round((float)$quote->getGrandTotal(), 2),
            'process_type' => 'DEFAULT',
            'product_type' => $product_type,
            'cart' =>
                array(
                    'id' => $quote->getId(),
                    'cart_price' => round((float)$quote->getGrandTotal(), 2),
                    'shipping_price' => round((float)$shipping_address->getShippingAmount(), 2),
                    'products' => $products
                ),
            'applicant' =>
                array(
                    'id' => $customer != null && $customer->getId() != null ? (int)$customer->getId().'' : '0',
                    'document_id' => null,
                    'name' => $customer != null && $customer->getId() != null  ? $customer->getFirstname() : $billing_address->getFirstname(),
                    'last_name' => $customer != null && $customer->getId() != null  ? $customer->getLastname() : $billing_address->getLastname(),
                    'email' => $customer != null && $customer->getId() != null  ? $customer->getEmail() : $email,
                    'group' => $customer != null && $customer->getId() != null  ? $customer->getGroupId().'' : '0',
                    'gender' => $customer != null && $customer->getId() != null  ? $customer->getGender() : null,
                    'birthday' => $customer != null && $customer->getId() != null  ? $customer->getDob() : null,
                    'billing_address' => array(
                        'country' => $billing_address->getCountry(),
                        'city' => $billing_address->getCity(),
                        'province' => $billing_address->getRegion(),
                        'postal_code' => $billing_address->getPostcode(),
                        'address' => $billing_address->getStreetFull(),
                        'phone' => $phone1
                    ),
                    'shipping_address' => $shipping_address_data
                ),
            'url_callback' => $baseURL."pepper/checkout/notify"
        );

        if ($addCartUrl) {
            $json['cart_url'] = $baseURL."checkout";
        }

        if ($viewMode) {
            $json['view_mode'] = $viewMode;
        }

        return $json;
    }

    private function check_shipping_address($ship_country, $ship_city, $ship_state, $ship_postal_code, $ship_address, $phone) {
        $shipping_address = null;
        if (isset($ship_country, $ship_city, $ship_state, $ship_postal_code, $ship_address, $phone)) {
            if (!(empty($ship_country)||empty($ship_city)||empty($ship_postal_code)||empty($ship_address)||empty($phone))) {
                $shipping_address = array(
                    'country' => $ship_country,
                    'city' => $ship_city,
                    'province' => $ship_state,
                    'postal_code' => $ship_postal_code,
                    'address' => $ship_address,
                    'phone' => $phone
                );
            }
        }

        return $shipping_address;
    }
}

