

/*browser:true*/
/*global define*/
define(
    [
        'jquery',
        'Magento_Checkout/js/view/payment/default',
        'Magento_Checkout/js/action/set-payment-information',
        'Magento_Checkout/js/model/payment/additional-validators',
        'Magento_Checkout/js/model/place-order',
        'Magento_Checkout/js/action/select-payment-method',
        'Magento_Customer/js/model/customer',
        'Magento_Checkout/js/checkout-data',
        'mage/url',
    ],
    function (
        $,
        Component,
        setPaymentInformationAction,
        additionalValidators,
        placeOrderService,
        selectPaymentMethodAction,
        customer,
        checkoutData,
        url) {
            'use strict';
    
            var pepperConfigProvider = window.checkoutConfig.payment.pepper;
            var pepperNConfigProvider = window.checkoutConfig.payment.pepper_n;
            var totals = window.checkoutConfig.totalsData;

            return Component.extend({
                defaults: {
                    template: 'Pepper_Money/payment/pepper'
                },
                isPaymentN: false,
                termDVN: 0,
                placeOrder: function (data, event) {
                    if (event) {
                        event.preventDefault();
                    }
                    var self = this,
                        emailValidationResult = customer.isLoggedIn(),
                        loginFormSelector = 'form[data-role=email-with-possible-login]';
                    if (!customer.isLoggedIn()) {
                        $(loginFormSelector).validation();
                        emailValidationResult = Boolean($(loginFormSelector + ' input[name=username]').valid());
                    }
                    if (emailValidationResult && this.validate() && additionalValidators.validate()) {
                        this.isPlaceOrderActionAllowed(false);
    
                        $.when(
                            setPaymentInformationAction(
                                this.messageContainer,
                                {
                                    method: this.getCode()
                                }
                            )
                        )
                        .then(this.afterPlaceOrder.bind(this))
                        .fail(
                            function () {
                                self.isPlaceOrderActionAllowed(true)
                            }
                        )
                        return true;
                    }
                    return false;
                },
    
                selectPaymentMethod: function() {
                    //selectPaymentMethodAction(this.getData());
                    this.isPaymentN = false;
                    let data = this.getData();
                    data.method='pepper';
                    selectPaymentMethodAction(data);
                    checkoutData.setSelectedPaymentMethod(this.item.method);
                    return true;
                },
                
                selectPaymentNMethod: function() {
                    this.isPaymentN = true;
                    let data = this.getData();
                    data.method='pepper_n';
                    selectPaymentMethodAction(data);
                    checkoutData.setSelectedPaymentMethod(this.item.method);
                    return true
                },

                afterPlaceOrder: function () {
                    if (!this.isPaymentN) {
                        if (pepperConfigProvider.iframe) {
                            document.getElementById('peppermodal').style.display = 'flex';
                            document.getElementById('peppermodaliframe').src = url.build('pepper/checkout/redirect/');
                        } else {
                            window.location.replace(url.build('pepper/checkout/redirect/'));
                        }
                    }

                    if (pepperNConfigProvider) {
                        if (this.isPaymentN) {
                            if (pepperNConfigProvider.iframe) {
                                document.getElementById('peppernmodal').style.display = 'flex';
                                document.getElementById('peppernmodaliframe').src = url.build('pepper/checkout/redirect/?n=yes');
                            } else {
                                window.location.replace(url.build('pepper/checkout/redirect/?n=yes'));
                            }
                        }
                    }
                },
    
                getApi: function () {
                    return pepperConfigProvider.api;
                },
    
                getDescription: function () {
                    return pepperConfigProvider.description;
                },
    
                getWidth: function () {
                    return pepperConfigProvider.width;
                },
    
                getImage: function () {
                    return pepperConfigProvider.image;
                },
    
                getIframe: function () {
                    return pepperConfigProvider.iframe;
                },
                getTitleN: function() {
                    let title = '';
                    if (pepperNConfigProvider) {
                        if (this.termDVN > 0) {
                            title = pepperNConfigProvider.title;
                            title = title.replace('{{NumCuotas}}', this.termDVN)
                        }
                    }
                    return title;
                },
                getDescriptionN: function () {
                    return (pepperNConfigProvider) ? pepperNConfigProvider.description : '';
                },
                getCodeN: function(){
                    let code = 'pepper_n';
                    return code;
                },
                isCheckedN: function(){
                    let checked = this.isChecked();
                    return checked;
                },
                showPaymentN: function() {
                    let show = false;
                    if (pepperNConfigProvider) {
                        show = this.showPaymentNWithQuotes();
                    }
                    return show;
                },
                showPaymentNWithQuotes: function() {
                    this.termDVN = 0;
                    let show = false;
                    let amount = totals.base_grand_total;
                    let data_dvn = PEPPER.widgets.getFinancialInfo(amount, null, 'total', 'DVN');
                    if (data_dvn.payment && data_dvn.term > 0) {
                        this.termDVN = data_dvn.term;
                        show = true;
                    }
                    return show;
                }
            });
        }
    );
