<?php

require_once dirname(__FILE__) . '/../../lib/Pepper/Client.php';

class PepperCartdataModuleFrontController extends ModuleFrontController
{
    protected $id_cart = null;

    protected function get_client_config() {
        return array(
            'api_url' => Configuration::get('pepper_api_url'),
            'public_key' => Configuration::get('pepper_public_key'),
            'secret_key' => Configuration::get('pepper_secret_key')
        );
    }

    /**
     * @return false|string
     * Returns a JSON with all the allowed relevant data about a certain user ID.
     */
    public function initContent()
    {
        $data = $this->gatherCartData();

        die(json_encode($data));
    }

    public function gatherCartData()
    {
        $config = $this->get_client_config();
        $pepper_client = new Pepper\Client($config['public_key'], $config['secret_key'], $config['api_url']);

        $request = (array)json_decode(file_get_contents('php://input'));

        if ($request == null) {
            http_response_code(400);
            return ['error' => 'Missing request parameters'];
        }

        $signature = $request['signature'];       
        $id_cart = $request['cart_id'];
        $this->id_cart = $id_cart;

        if ($this->id_cart == null) {
            http_response_code(400);
            return ['error' => 'Missing request parameters'];
        }

        if (!$pepper_client->checkCartDataSignature($request, $signature)) {
            http_response_code(401);
            return ['error' => 'Wrong signature'];
        }

        if ((!$cart = new Cart((int) $this->id_cart)) || !is_object($cart) || $cart->id === null) {
            http_response_code(404);
            return ['error' => sprintf('Unable to load cart by card id "%d".', $this->id_cart)];
        }

        if ($cart->orderExists()) {
            http_response_code(400);
            return ['error' => 'Cart paid'];
        }

        $config = $this->get_client_config();
        $pepper_client = new Pepper\Client($config['public_key'], $config['secret_key'], $config['api_url']);
        $customer = new Customer((int) $cart->id_customer);
        $address = new Address((int)$cart->id_address_delivery);
        $address_invoice = new Address((int)$cart->id_address_invoice);
        $json = $pepper_client->getCartData(
            $cart, 
            $customer, 
            $address, 
            $address_invoice, 
            State::getNameById($address->id_state), 
            State::getNameById($address_invoice->id_state), 
            $this->module, 
            $this->context, 
            false, 
            null,
            'STD'
        );

        return $json;
    }
}
