<?php

require_once dirname(__FILE__) . '/../../lib/Pepper/Client.php';

class PepperDatatransferModuleFrontController extends ModuleFrontController
{

    protected $id_customer = null;
    protected $id_cart = null;

    protected function get_client_config() {
        return array(
            'api_url' => Configuration::get('pepper_api_url'),
            'public_key' => Configuration::get('pepper_public_key'),
            'secret_key' => Configuration::get('pepper_secret_key')
        );
    }

    /**
     * @return false|string
     * Returns a JSON with all the allowed relevant data about a certain user ID.
     */
    public function initContent()
    {
        $data = $this->gatherAllData();

        die(json_encode($data));
    }

    public function gatherAllData()
    {
        $config = $this->get_client_config();
        $pepper_client = new Pepper\Client($config['public_key'], $config['secret_key'], $config['api_url']);

        $checkOutInformation = (array)json_decode(file_get_contents('php://input'));

        if ($checkOutInformation == null) {
            http_response_code(400);
            return ['error' => 'Missing request parameters'];
        }

        $signature = $checkOutInformation['signature'];        
        $id_cart = $checkOutInformation['cart_id'];
        $this->id_cart = $id_cart;
        $this->id_customer = $checkOutInformation['customer_id'];

        if ($this->id_cart == null) {
            http_response_code(400);
            return ['error' => 'Missing request parameters'];
        }

        if (!$pepper_client->checkMacroDataSignature($checkOutInformation, $signature)) {
            http_response_code(401);
            return ['error' => 'Wrong signature'];
        }
        
        if ((!$cart = new Cart((int) $this->id_cart)) || !is_object($cart) || $cart->id === null) {
            http_response_code(404);
            return ['error' => sprintf('Unable to load cart by card id "%d".', $this->id_cart)];
        }

        $resultData = array();

        foreach ($checkOutInformation['requested_data'] as $data => $allowed)
        {
            if ($allowed){
                switch ($data)
                {
                    case $data == 'client_data':
                        $resultData = array_merge($resultData, $this->getClientData());
                        break;
                    case $data == 'historical':
                        try{
                            $resultData = array_merge($resultData, $this->getHistorical());
                        } catch (PrestaShopDatabaseException $e) {}
                        break;
                    case $data == 'lost_carts':
                        $resultData = array_merge($resultData, $this->getLostCarts());
                        break;
                    case $data == 'images':
                        $resultData = array_merge($resultData, $this->getImages());
                        break;
                    default :
                        break;
                }
            }
        }

        return $resultData;
    }

    /**
     * @return array|string
     */
    private function getClientData()
    {
        $customer = new Customer($this->id_customer);

        $clientData = array(
            'entity_id' => intval($customer->id),
            'website_id' => $customer->id_shop_group,
            'email' => $customer->email,
            'group_id' => $customer->id_default_group,
            'store_id' => $customer->id_shop,
            'created_at' => $customer->date_add,
            'updated_at' => $customer->date_upd,
            'is_active' => $customer->active,
            'dob' => $customer->birthday,
            'gender' => $customer->id_gender,
            'first_name' => $customer->firstname,
            'last_name' => $customer->lastname
        );

        if ($clientData != null){
            return array('client_data' => $clientData);
        } else {
            return array('client_data' => array());
        }
    }

    /**
     * @return array|string
     * @throws PrestaShopDatabaseException
     */
    private function getHistorical()
    {
        $historicalData = array();

        $query = 'SELECT * FROM ' . _DB_PREFIX_ . 'orders WHERE ' . _DB_PREFIX_ . 'orders.id_customer = ' . $this->id_customer;
        $result = Db::getInstance()->ExecuteS($query);

        foreach ($result as $order){
            $orderData = array(
                'entity_id' => intval($order['id_order']),
                'increment_id' => $order['reference'],
                'state' => $order['current_state'],
                'store_id' => $order['id_shop'],
                'customer_id' => $order['id_customer'],
                'subtotal' => round($order['total_products'], 2),
                'grand_total' => round($order['total_paid'], 2),
                'discount_amount' => round($order['total_discounts'], 2),
                'shipping_amount' => round($order['total_shipping'], 2),
                'created_at' => $order['date_add'],
                'updated_at' => $order['date_upd'],
                'products' => array()
            );

            $query = 'SELECT * FROM ' . _DB_PREFIX_ . 'order_detail WHERE id_order='.$order['id_order'];
            $orderItems = Db::getInstance()->ExecuteS($query);

            foreach ($orderItems as $item){
                $itemData = array(
                    // 'item_id' => intval($item['id_order_detail']),
                    // 'order_id' => $item['id_order'],
                    'product_id' => $item['product_id'],
                    'name' => $item['product_name'],
                    'price' => round($item['product_price'], 2),
                    'quantity' => $item['product_quantity']
                );

                array_push($orderData['products'], $itemData);
            }

            array_push($historicalData, $orderData);
        }

        if ($historicalData != null) {
            return array('historical' => $historicalData);
        } else {
            return array('historical' => array());
        }
    }

    /**
     * @return array|string
     * @throws PrestaShopDatabaseException
     */
    private function getLostCarts()
    {
        $lostCartData = array();

        $query = 'SELECT * FROM ' . _DB_PREFIX_ . 'cart WHERE id_customer='.$this->id_customer;
        $lostCarts = Db::getInstance()->ExecuteS($query);

        foreach ($lostCarts as $cart){
            if ($cart['id_cart'] == $this->id_cart) {
                continue;
            }

            $queryOrders = 'SELECT * FROM ' . _DB_PREFIX_ . 'orders WHERE id_cart='.$cart['id_cart'];
            $orders = Db::getInstance()->ExecuteS($queryOrders);

            if (count($orders) !== 0) {
                continue;
            }

            $cartData = array(
                'entity_id' => intval($cart['id_cart']),
                'store_id' => $cart['id_shop'],
                'created_at' => $cart['date_add'],
                'updated_at' => $cart['date_upd'],
                'products' => array()
            );

            $query = 'SELECT cp.quantity, p.price, p.id_product FROM ' . _DB_PREFIX_ . 'cart AS c INNER JOIN ' . _DB_PREFIX_ . 'cart_product AS cp ON c.id_cart = cp.id_cart 
                INNER JOIN ' . _DB_PREFIX_ . 'product AS p ON cp.id_product = p.id_product INNER JOIN
                ' . _DB_PREFIX_ . 'product_lang AS pl ON p.id_product = pl.id_product WHERE c.id_cart = '. $cart['id_cart'];
            $cartItems = Db::getInstance()->ExecuteS($query);

            foreach ($cartItems as $item){
                $itemData = array(
                    'product_id' => intval($item['id_product']),
                    'price' => round($item['price'], 2),
                    'quantity' => $item['quantity']
                );

                array_push($cartData['products'], $itemData);
            }

            array_push($lostCartData, $cartData);
        }

        if ($lostCartData != null){
            return array('lost_carts' => $lostCartData);
        } else {
            return array('lost_carts' => array());
        }
    }

    /**
     * @return array|string
     * @throws PrestaShopDatabaseException
     */
    private function getImages(){
        $imagesArray = array();

        $currentCartQuery = 'SELECT p.* FROM ' . _DB_PREFIX_ . 'cart AS c  INNER JOIN ' . _DB_PREFIX_ . 'cart_product AS cp ON c.id_cart = cp.id_cart 
                INNER JOIN ' . _DB_PREFIX_ . 'product AS p ON cp.id_product = p.id_product INNER JOIN
                ' . _DB_PREFIX_ . 'product_lang AS pl ON p.id_product = pl.id_product WHERE c.id_customer = '.$this->id_customer.'
                AND c.id_cart = '.$this->id_cart;

        $cartProducts = Db::getInstance()->ExecuteS($currentCartQuery);

        foreach ($cartProducts as $product)
        {
            $image_id = Db::getInstance()->ExecuteS('SELECT id_image FROM ' . _DB_PREFIX_ . 'image WHERE cover = 1 AND id_product = '.$product['id_product'])[0]['id_image'];

            $imgPath = 'img/p/';
            for ($i = 0; $i < strlen($image_id); $i++) {
                $imgPath .= $image_id[$i] . '/';
            }
            $imgPath .= $image_id . '.jpg';

            $image64 = base64_encode(file_get_contents($imgPath));

            array_push($imagesArray, array(
                'id' => $product['id_product'],
                'imageB64' => $image64
            ));
        }

        if ($imagesArray != ''){
            return array('images' => $imagesArray);
        } else {
            return array('images' => array());
        }
    }
}
