<?php
/**
 * Pepper Module
 *
 * Copyright (c) 2020 Pepper
 *
 * @category  Payment
 * @author    Pepper
 * @copyright 2020, Pepper
 * @link      https://peppermoney.es/
 * @license   http://opensource.org/licenses/osl-3.0.php Open Software License (OSL 3.0)
 *
 * Description:
 *
 * Plugin de Prestashop para conectar con la pasarela de Pepper.
 *
 * --
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Open Software License (OSL 3.0)
 * that is bundled with this package in the file LICENSE.
 * It is also available through the world-wide-web at this URL:
 * http://opensource.org/licenses/osl-3.0.php
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to soporte@peppermoney.es so we can send you a copy immediately.
 */

require_once dirname(__FILE__) . '/../../lib/Pepper/Client.php';

class PepperPaymentModuleFrontController extends ModuleFrontController
{
    public $ssl = true;

    /**
     *
     * @see FrontController::initContent()
     */
    public function initContent()
    {
        $this->display_column_left = false;
        $this->display_column_right = false;

        parent::initContent();

        if (!$this->module->isPayment()) {
            throw new \Exception(sprintf(
                '%s Error: (Inactive or incomplete module configuration)',
                $this->module->displayName
            ));
        }

        $cart = $this->context->cart;

        $config = $this->get_client_config();
        $pepper_client = new Pepper\Client($config['public_key'], $config['secret_key'], $config['api_url']);
        $customer = new Customer((int) $cart->id_customer);
        $address = new Address((int)$cart->id_address_delivery);
        $address_invoice = new Address((int)$cart->id_address_invoice);
        $json = $pepper_client->getCartData(
            $cart, 
            $customer, 
            $address, 
            $address_invoice, 
            State::getNameById($address->id_state), 
            State::getNameById($address_invoice->id_state), 
            $this->module, 
            $this->context, 
            true, 
            $config['integration'],
            array_key_exists('n', $_GET) ? ($_GET['n'] == 'SI' ? 'DVN' : 'STD') : 'STD'
        );

		setcookie("managed_mode", "", time()-3600);
        die($pepper_client->getForm($json));
    }

    protected function get_client_config() {
        return array(
            'api_url' => Configuration::get('pepper_api_url'),
            'public_key' => Configuration::get('pepper_public_key'),
            'secret_key' => Configuration::get('pepper_secret_key'),
            'integration' => Configuration::get('pepper_integration')
        );
    }
}

