<?php
namespace Pepper;

class Client
{
    public $apiUrl = 'https://api-ecommerce.peppermoney.es/v1/';
    private $publicKey = 'test';
    private $secretKey = 'test';

    public function __construct($publicKey, $secretKey, $apiUrl)
    {
        $this->publicKey = $publicKey;
        $this->secretKey = $secretKey;
        $this->apiUrl = $apiUrl;
        return $this;
    }

    public function getPlaceOrderPath($path = '')
    {
        return $this->apiUrl.'place-order/';
    }

    public function getForm($json_dict)
    {
        $html = '<form id="pepper-form" action="'.$this->getPlaceOrderPath().'" method="post">'.$this->getFields($json_dict).'</form>'.'<script>document.getElementById("pepper-form").submit();</script>';
        return trim($html);
    }

    public function getFields($json_dict)
    {
        $json_dict_encoded = base64_encode(json_encode($json_dict));
        $signature = $this->getSignature($json_dict);

        $html = '';
        $html .= "\n".'<input type="hidden" name="params" value="'.$json_dict_encoded.'" />';
        $html .= "\n".'<input type="hidden" name="signature" value="'.$signature.'" />';

        return trim($html);
    }

    public function getSignature($json_dict)
    {
        $key = $json_dict['platform'].$json_dict['order_date'].$json_dict['transaction_id'].$json_dict['total_price'].$this->secretKey;
        return hash('sha256', $key);
    }

    public function checkSignature($json_dict, $signature)
    {
        $key = $json_dict['result'].$json_dict['cart_id'].$this->secretKey;
        return hash('sha256', $key) == $signature;
    }

    public function checkMacroDataSignature($json_dict, $signature)
    {
        $key = 'PEN'.$json_dict['cart_id'].$this->secretKey;
        return hash('sha256', $key) == $signature;
    }

    public function checkCartDataSignature($json_dict, $signature)
    {
        $key = 'NEW'.$json_dict['cart_id'].$this->secretKey;
        return hash('sha256', $key) == $signature;
    }

    public function getRandomNumber()
    {
        # To generate random number
        srand(time());
        return rand(10, 99);
    }

    public function removeRandomNumber($value)
    {
        return substr($value, 0, -2);
    }

    public function getCartData($cart, $customer, $address, $address_invoice, $ship_state, $state, $module, $context, $addCartUrl, $viewMode, $product_type) {
        $url = array(
            'cancel' => $context->shop->getBaseURL(true) . 'index.php?controller=order&step=3'
        );

        if (_PS_VERSION_ <= '1.5') {
            $url['notify'] = $context->shop->getBaseURL(true) . 'modules/' . $module->name . '/validation.php';
            $url['return'] = $context->shop->getBaseURL(true) . 'index.php?controller=order-confirmation&id_cart='.
                $cart->id.'&id_module='.$module->id.'&id_order='.$module->currentOrder.'&key='.
                $customer->secure_key;
        } else {
            if (_PS_VERSION_ >= '1.7' || defined('_TB_VERSION_')) {
                $url['notify'] = $context->link->getModuleLink($module->name, 'validation', [], true);
            } else {
                $url['notify'] = $context->shop->getBaseURL(true) . 'modules/' . $module->name . '/validation.php';
            }
            $url['return'] = $context->link->getPageLink('order-confirmation', null, null, array(
                'id_cart' => $cart->id,
                'id_module' => $module->id,
                'key' => $customer->secure_key,
                'id_order' => $module->currentOrder
            ));
        }

        $pepper_client = $this;

        $first_name = $customer->firstname;
        $last_name = $customer->lastname;
        $this->check_fill_first_last_name($first_name, $last_name);
        $email = $customer->email;
        $city = $address_invoice->city;
        $country = $address_invoice->country;
        $line1 = $address_invoice->address1;
        $line2 = $address_invoice->address2;
        $line3 = '';
        $postal_code = $address_invoice->postcode;
        $dni = $address_invoice->dni == '' ? null : $address_invoice->dni;
        if (!$state) {
            $state = null;
        }
		$phones = array();
		
        if (isset($address_invoice->phone_mobile) && !empty($address_invoice->phone_mobile)) {
			array_push($phones, $address_invoice->phone_mobile);
		}
        if (isset($address->phone_mobile) && !empty($address->phone_mobile)) {
			if (!in_array($address->phone_mobile, $phones))
				array_push($phones, $address->phone_mobile);
        }
		if (isset($address_invoice->phone) && !empty($address_invoice->phone)) {
			if (!in_array($address_invoice->phone, $phones))
				array_push($phones, $address_invoice->phone);
        }
		if (isset($address->phone) && !empty($address->phone)) {
			if (!in_array($address->phone, $phones))
				array_push($phones, $address->phone);
        }
		
        $phone1 = '';
        $phone2 = '';
		if (count($phones) > 0) {
            $phone1 = $phones[0];
            $phone2 = $phones[0];
            if (count($phones)>1)
            {
                $phone2 = $phones[1];
            }
        }
        if (strlen($phone1) < 9) {
            $phone1 = '';
        }
        if (strlen($phone2) < 9) {
            $phone2 = '';
        }
		
        $ship_city = $address->city;
        $ship_country = $address->country;
        $ship_line1 = $address->address1;
        $ship_line2 = $address->address2;
        $ship_line3 = '';
        $ship_postal_code = $address->postcode;
        if (!$ship_state) {
            $ship_state = null;
        }
        $ship_dni = $address->dni == '' ? null : $address->dni;

        $data = json_decode('{"term":0,"externalData":"N/A","transactionId":"N/A","term_dvn":0}');
        if ( isset($_COOKIE['send_pepper_info']) ) {
            $data = json_decode(stripslashes($_COOKIE['send_pepper_info']));
        }
		$process_type = 'DEFAULT';
		if (isset($_COOKIE['managed_mode'])) {
			$process_type = 'MANAGED';
		}

        $term = $product_type == 'STD' ? intval($data->term) : intval($data->term_dvn);

        $products = array();
        $total_products = 0;
        $cart_products = $cart->getProducts(true);
        //Fill Products
        foreach ($cart_products as $item) {
            $product_id = $item['id_product'];
            $product_reference = $item['reference'];
            $product_name = $item['name'];
            $product_quantity = intval($item['quantity']);
            $product_price = $item['price'];
            $total_products += $product_quantity;

            if (!isset($product_reference) || empty($product_reference)) {
                $product_reference = 'YYY';
            }

            $products[] = array(
                'id' => $product_id.'',
                'reference' => $product_reference.'',
                'name' => $product_name,
                'qty' => $product_quantity,
                'price' => $product_price,
                'attributes' => null
            );
        }

        //check shipping address (if any field is empty returns null).
        $shipping_address = $this->check_shipping_address($ship_country, $ship_city, $ship_state, $ship_postal_code, $ship_line1, $ship_line2, $phone2);

        $json = array(
            'platform' => 'PSH17',
            'order_date' => date('Y-m-d'),
            'transaction_id' => $data->transactionId,
            'term' => intval($term),
            'total_products' => $total_products,
            'total_price' => $cart->getOrderTotal(),
            'process_type' => $process_type,
            'product_type' => $product_type,
            'cart' =>
                array(
                    'id' => $cart->id.'',
                    'cart_price' => $cart->getOrderTotal(),
                    'shipping_price' => $cart->getTotalShippingCost(),
                    'products' => $products
                ),
            'applicant' =>
                array(
                    'id' => strval($customer->id),
                    'document_id' => $dni,
                    'name' => $first_name,
                    'last_name' => $last_name,
                    'email' => $email,
                    'group' => $customer->id_default_group.'',
                    'gender' => $customer->id_gender.'',
                    'birth_date' => $customer->birthday == "0000-00-00" ? null : $customer->birthday,
                    'billing_address' => array(
                        'country' => $country,
                        'city' => $city,
                        'province' => $state,
                        'postal_code' => $postal_code,
                        'address' => $line1 . ' ' . $line2,
                        'phone' => $phone1
                    ),
                    'shipping_address' => $shipping_address
                ),
            'url_callback' => $url['notify']
        );

        if ($addCartUrl) {
            $json['cart_url'] = $url['cancel'];
        }

        if ($viewMode) {
            $json['view_mode'] = $viewMode;
        }
        return $json;
    }

    private function check_shipping_address($ship_country, $ship_city, $ship_state, $ship_postal_code, $ship_line1, $ship_line2, $phone){
        $isOK = false;
        $shipping_address = null;
        $ship_lines = $ship_line1.$ship_line2;
        if(isset($ship_country, $ship_city, $ship_state, $ship_postal_code, $ship_lines, $phone)){
            if(!(empty($ship_country)||empty($ship_city)||empty($ship_postal_code)||empty($ship_lines)||empty($phone))){
                $shipping_address = array(
                    'country' => $ship_country,
                    'city' => $ship_city,
                    'province' => $ship_state,
                    'postal_code' => $ship_postal_code,
                    'address' => $ship_line1 . ' ' . $ship_line2,
                    'phone' => $phone
                );
            }
        }

        return $shipping_address;
    }

    private function check_fill_first_last_name(&$first_name, &$last_name){
        if(empty($last_name)){
            $fn_parts = explode(' ', $first_name);
            
            if(count($fn_parts)>1){
                $first_name = array_shift($fn_parts);
                $last_name = implode(' ', $fn_parts);
            }else{
                $first_name = $fn_parts[0];
                $last_name = $first_name;
            }
        }
    }
}

