/**
 * Pepper Module
 *
 * Copyright (c) 2020 Pepper
 *
 * @category  Payment
 * @author    Pepper
 * @copyright 2020, Pepper
 * @link      https://peppermoney.es/
 * @license   http://opensource.org/licenses/osl-3.0.php Open Software License (OSL 3.0)
 *
 * Description:
 *
 * Plugin de Prestashop para conectar con la pasarela de Pepper.
 *
 * --
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Open Software License (OSL 3.0)
 * that is bundled with this package in the file LICENSE.
 * It is also available through the world-wide-web at this URL:
 * http://opensource.org/licenses/osl-3.0.php
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to soporte@peppermoney.es so we can send you a copy immediately.
 */
var HTML = '<div><a id="go_order_process_pepper" class="btn btn-link _blank">Abrir con Pepper Managed.&nbsp;<i class="icon-external-link"></i></a><a href="." id="targetPepper" target="_blank" style="display:none"></a></div>';
//Esperamos a finalizar la carga del DOM para empezar a funcionar:
document.addEventListener("DOMContentLoaded", function(event) {
	if (window.location.href.indexOf('addorder') !== -1) createPepperObserver();
});
function createPepperObserver(){
	var observer = new MutationObserver(function(mutation) {
		if (document.getElementById('go_order_process')) //condicion de clonar y terminar
		{
			var aux = document.createRange().createContextualFragment(HTML);
			var btn = aux.getElementById('go_order_process_pepper');
			btn.addEventListener('click', openManagedMode);
			var elmt = document.getElementById('go_order_process');
			elmt.insertAdjacentElement('afterend', aux.firstChild);
			disconnect();
		}
	});
	function disconnect(){
		observer.disconnect();
	}
	var config = { childList: true, subtree: true };
	observer.observe(document.body, config);
}
function openManagedMode() {
	var aux = document.getElementById('go_order_process');
	var link = document.getElementById('targetPepper');
	link.href = aux.href + '&managed_mode';
	link.click();
}