{**
 * Pepper Module
 *
 * Copyright (c) 2020 Pepper
 *
 * @category  Payment
 * @author    Pepper
 * @copyright 2020, Pepper
 * @link      https://peppermoney.es/
 * @license   http://opensource.org/licenses/osl-3.0.php Open Software License (OSL 3.0)
 *
 * Description:
 *
 * Plugin de Prestashop para conectar con la pasarela de Pepper.
 *
 * --
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Open Software License (OSL 3.0)
 * that is bundled with this package in the file LICENSE.
 * It is also available through the world-wide-web at this URL:
 * http://opensource.org/licenses/osl-3.0.php
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to soporte@peppermoney.es so we can send you a copy immediately.
 *}

{literal}
<style type="text/css">
fieldset a {
    color:#0099ff !important;
    text-decoration:underline;
}
fieldset a:hover {
    color:#000000;
    text-decoration:underline;
}
.level1 {
    font-size:1.2em
}
.level2 {
    font-size:0.9em
}
</style>
{/literal}

<div><img src="{$pepper.dfl.img_path|escape:'htmlall':'UTF-8'}" width="100" title="" /></div>
<form method="post" action="{$pepper.dfl.action|escape:'htmlall':'UTF-8'}">
<br />

<fieldset class="level1">
<legend>{l s='Acerca de Pepper' mod='pepper'}</legend>
    <b>{l s='Permite utilizar la pasarela de Pepper en tu sitio web.' mod='pepper'}</b> <a target="_blank" href="https://pepperfinance.es/"><b>{l s='https://pepperfinance.es/.' mod='pepper'}</b></a><br />
</fieldset>
<br />

<fieldset class="level1">
    <legend>{l s='Configuración' mod='pepper'}</legend>
    <b>{l s='Para usar el plugin es necesario definir algunos campos:' mod='pepper'}</b><br /><br />
    
    <fieldset class="level2">
        <label>{l s='API Key' mod='pepper'}</label>
        <div class="margin-form">
            <input type="text" name="api_key" value="{$pepper.config.pepper_api_key|escape:'htmlall':'UTF-8'}" />
            <p>{l s='Lo puede dejar en blanco para deshabilitar el plugin' mod='pepper'}</p>
        </div>
        <div class="clear"></div>
        <label>{l s='Clave pública' mod='pepper'}</label>
        <div class="margin-form">
            <input type="text" name="public_key" value="{$pepper.config.pepper_public_key|escape:'htmlall':'UTF-8'}" />
            <p>{l s='Lo puede dejar en blanco para deshabilitar el plugin' mod='pepper'}</p>
        </div>
        <div class="clear"></div>
        <label>{l s='Clave secreta' mod='pepper'}</label>
        <div class="margin-form">
            <input type="text" name="secret_key" value="{$pepper.config.pepper_secret_key|escape:'htmlall':'UTF-8'}" />
            <p>{l s='Lo puede dejar en blanco para deshabilitar el plugin' mod='pepper'}</p>
        </div>
        <div class="clear"></div>
        <label>{l s='API URL' mod='pepper'}</label>
        <div class="margin-form">
            <input type="text" name="api_url" value="{$pepper.config.pepper_api_url|escape:'htmlall':'UTF-8'}" />
            <p>{l s='Lo puede dejar en blanco para deshabilitar el plugin' mod='pepper'}</p>
        </div>
        <div class="clear"></div>
        <label>{l s='Entorno' mod='pepper'}</label>
        <div class="margin-form">
            <select name="environment">
                <option value="PRO" {if $pepper.config.pepper_environment eq 'PRO'}selected{/if}>Producción</option>
                <option value="TST" {if $pepper.config.pepper_environment eq 'TST'}selected{/if}>Test</option>
            </select>
        </div>
        <div class="clear"></div>
        <label>{l s='Forma de integración' mod='pepper'}</label>
        <div class="margin-form">
            <select name="integration">
                <option value="DEFAULT" {if $pepper.config.pepper_integration eq 'DEFAULT'}selected{/if}>Redirección</option>
                <option value="IFRAME" {if $pepper.config.pepper_integration eq 'IFRAME'}selected{/if}>iFrame</option>
            </select>
        </div>
        <div class="clear"></div>
        <label>{l s='Estado del pedido al confirmar el pago' mod='pepper'}</label>
        <div class="margin-form">
            <select name="payment_status">
			{foreach from=$pepper.status item=option}
				<option value="{$option.value|default:''|escape:'htmlall':'UTF-8'}" {if $option.value eq $pepper.pepper_payment_status} selected {/if}>{$option.title|default:''|escape:'htmlall':'UTF-8'}</option>
			{/foreach}
			</select>
            <p>{l s='Estado del pedido cuando se confirma el pago con Pepper'}</p>
        </div>
        <div class="clear"></div>
        <label>{l s='Título' mod='pepper'}</label>
        <div class="margin-form">
            <input type="text" name="title" value="{$pepper.config.pepper_title|escape:'htmlall':'UTF-8'}" />
            <p>{l s='Título mostrado al cliente durante el proceso de compra con este método de pago. Lo puede dejar en blanco para deshabilitar el plugin' mod='pepper'}</p>
        </div>
        <div class="clear"></div>
        <label>{l s='Descripción' mod='pepper'}</label>
        <div class="margin-form">
            <input type="text" name="description" value="{$pepper.config.pepper_description|escape:'htmlall':'UTF-8'}" />
            <p>{l s='Descripción mostrada al cliente durante el proceso de compra con este método de pago. Lo puede dejar en blanco para deshabilitar el plugin' mod='pepper'}</p>
        </div>
        <div class="clear"></div>
        <label>{l s='Opción Divide N' mod='pepper'}</label>
        <div class="margin-form">
            <select name="enable_n">
                <option value="SI" {if $pepper.config.pepper_enable_n eq 'SI'}selected{/if}>Sí</option>
                <option value="NO" {if $pepper.config.pepper_enable_n eq 'NO'}selected{/if}>No</option>
            </select>
        </div>
        <div class="clear"></div>
        <label>{l s='Título Opción Divide N' mod='pepper'}</label>
        <div class="margin-form">
            <input type="text" name="title_n" value="{$pepper.config.pepper_title_n|escape:'htmlall':'UTF-8'}" />
            <p>{l s='Título mostrado al cliente durante el proceso de compra en la opción Divide N. Lo puede dejar en blanco para deshabilitar el plugin' mod='pepper'}</p>
        </div>
        <div class="clear"></div>
        <label>{l s='Descripción Opción Divide N' mod='pepper'}</label>
        <div class="margin-form">
            <input type="text" name="description_n" value="{$pepper.config.pepper_description_n|escape:'htmlall':'UTF-8'}" />
            <p>{l s='Descripción mostrada al cliente durante el proceso de compra en la opción Divide N. Lo puede dejar en blanco para deshabilitar el plugin' mod='pepper'}</p>
        </div>
        <div class="clear"></div>
        <label>{l s='Ancho de Logo en Checkout' mod='pepper'}</label>
        <div class="margin-form">
            <input type="text" name="logo_width" value="{$pepper.config.pepper_logo_width|escape:'htmlall':'UTF-8'}" />
            <p>{l s='Debe incluir al final px o % o cualquier unidad de medida. Lo puede dejar en blanco para deshabilitar el plugin' mod='pepper'}</p>
        </div>
        <div class="clear"></div>
		<div style="display: none">
        <label>{l s='Precio mínimo de calculadora' mod='pepper'}</label>
        <div class="margin-form">
            <input type="text" name="calc_min_amount" value="{$pepper.config.pepper_calc_min_amount|escape:'htmlall':'UTF-8'}" />
            <p>{l s='Precio mínimo para habilitar el pintado del widget. Lo puede dejar en 0 o -1 si quiere que siempre se pinte' mod='pepper'}</p>
        </div>
        <div class="clear"></div>
        <label>{l s='Precio máximo de calculadora' mod='pepper'}</label>
        <div class="margin-form">
            <input type="text" name="calc_max_amount" value="{$pepper.config.pepper_calc_max_amount|escape:'htmlall':'UTF-8'}" />
            <p>{l s='Precio máximo para habilitar el pintado del widget. Lo puede dejar en 0 o -1 si quiere que siempre se pinte' mod='pepper'}</p>
        </div>
        <div class="clear"></div>
		</div>
        <div class="margin-form clear pspace"><input type="submit" name="submitUpdate" value="{l s='Guardar' mod='pepper'}" class="button" /></div>
    </fieldset>
</fieldset>
</form>
<br />

<fieldset class="level1 space">
    <legend>{l s='Ayuda' mod='pepper'}</legend>
    <b>{l s='Para más información contáctenos a través del correo' mod='pepper'}</b> <a href="mailto:soporteintegracion@peppergroup.es"><b>{l s='soporteintegracion@peppergroup.es' mod='pepper'}</b></a>.<br /><br />
</fieldset>
