{**
 * Pepper Module
 *
 * Copyright (c) 2020 Pepper
 *
 * @category  Payment
 * @author    Pepper
 * @copyright 2020, Pepper
 * @link      https://peppermoney.es/
 * @license   http://opensource.org/licenses/osl-3.0.php Open Software License (OSL 3.0)
 *
 * Description:
 *
 * Plugin de Prestashop para conectar con la pasarela de Pepper.
 *
 * --
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Open Software License (OSL 3.0)
 * that is bundled with this package in the file LICENSE.
 * It is also available through the world-wide-web at this URL:
 * http://opensource.org/licenses/osl-3.0.php
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to soporte@peppermoney.es so we can send you a copy immediately.
 *}

<div id="pepper-product">
    <div style="display: none" id="pepper-product-price">{$price|escape:'htmlall'}</div>
    <div style="display: none" id="pepper-product-qty">1</div>
    <div id="pepper-product-widget"></div>
</div>

<script>
  document.addEventListener("DOMContentLoaded", function(event) {
    var element = document.getElementById('quantity_wanted');
    if (element) {
        element.onchange = function() {
            document.getElementById('pepper-product-qty').innerHTML = this.value;
        };
        setInterval(function () {
            var pepperElement = document.getElementById('pepper-product-qty');
            if (element.value != pepperElement.innerHTML) {
                pepperElement.innerHTML = element.value;
            }
        }, 500);
    }
  });
</script>