<?php
namespace Pepper;

class Client
{
    public $apiUrl = 'https://api-ecommerce.peppermoney.es/v1/';
    private $publicKey = 'test';
    private $secretKey = 'test';

    public function __construct($publicKey, $secretKey, $apiUrl)
    {
        $this->publicKey = $publicKey;
        $this->secretKey = $secretKey;
        $this->apiUrl = $apiUrl;
        return $this;
    }

    public function getPlaceOrderPath($path = '')
    {
        return $this->apiUrl.'place-order/';
    }

    public function getForm($json_dict)
    {
        $html = '<form id="pepper-form" action="'.$this->getPlaceOrderPath().'" method="post">'.$this->getFields($json_dict).'</form>'.'<script>document.getElementById("pepper-form").submit();</script>';
        return trim($html);
    }

    public function getFields($json_dict)
    {
        $json_dict_encoded = base64_encode(json_encode($json_dict));
        $signature = $this->getSignature($json_dict);

        $html = '';
        $html .= "\n".'<input type="hidden" name="params" value="'.$json_dict_encoded.'" />';
        $html .= "\n".'<input type="hidden" name="signature" value="'.$signature.'" />';

        return trim($html);
    }

    public function getSignature($json_dict)
    {
        $key = $json_dict['platform'].$json_dict['order_date'].$json_dict['transaction_id'].$json_dict['total_price'].$this->secretKey;
        return hash('sha256', $key);
    }

    public function checkSignature($json_dict, $signature)
    {
        $key = $json_dict['result'].$json_dict['cart_id'].$this->secretKey;
        return hash('sha256', $key) == $signature;
    }

    public function checkMacroDataSignature($json_dict, $signature)
    {
        $key = 'PEN'.$json_dict['cart_id'].$this->secretKey;
        return hash('sha256', $key) == $signature;
    }

    public function checkCartDataSignature($json_dict, $signature)
    {
        $key = 'NEW'.$json_dict['cart_id'].$this->secretKey;
        return hash('sha256', $key) == $signature;
    }

    public function getRandomNumber()
    {
        # To generate random number
        srand(time());
        return rand(10, 99);
    }

    public function removeRandomNumber($value)
    {
        return substr($value, 0, -2);
    }

    public function getCartData($order, $order_id, $notify_url, $addCartUrl, $viewMode, $product_type) {
        $user;
        $user_id;
        $user_data;

        $first_name = '';
        $last_name = '';
        $email = '';
        $city = '';
        $country = '';
        $line1 = '';
        $line2 = '';
        $line3 = '';
        $postal_code = '';
        $state = '';
        $phone = '';
        $ship_city = '';
        $ship_country = '';
        $ship_line1 = '';
        $ship_line2 = '';
        $ship_line3 = '';
        $ship_postal_code = '';
        $ship_state = '';
        if ( version_compare( WOOCOMMERCE_VERSION, '3.0', '<' ) ) {
            $first_name = $order->billing_first_name;
            $last_name = $order->billing_last_name;
            $this->check_fill_first_last_name($first_name, $last_name);
            $email = $order->billing_email;
            $city = $order->billing_city;
            $country = $order->billing_country;
            $line1 = $order->billing_address_1;
            $line2 = $order->billing_address_2;
            $postal_code = $order->billing_postcode;
            $state = $order->billing_state;
            $phone = $order->billing_phone;
            $ship_city = $order->shipping_city;
            $ship_country = $order->shipping_country;
            $ship_line1 = $order->shipping_address_1;
            $ship_line2 = $order->shipping_address_2;
            $ship_postal_code = $order->shipping_postcode;
            $ship_state = $order->shipping_state;

            $user = $order->user;
            $user_id = $order->user_id;
        } else {
            $first_name = $order->get_billing_first_name();
            $last_name = $order->get_billing_last_name();
            $this->check_fill_first_last_name($first_name, $last_name);
            $email = $order->get_billing_email();
            $city = $order->get_billing_city();
            $country = $order->get_billing_country();
            $line1 = $order->get_billing_address_1();
            $line2 = $order->get_billing_address_2();
            $postal_code = $order->get_billing_postcode();
            $state = $order->get_billing_state();
            $phone = $order->get_billing_phone();
            $ship_city = $order->get_shipping_city();
            $ship_country = $order->get_shipping_country();
            $ship_line1 = $order->get_shipping_address_1();
            $ship_line2 = $order->get_shipping_address_2();
            $ship_postal_code = $order->get_shipping_postcode();
            $ship_state = $order->get_shipping_state();

            $user = $order->get_user();
            $user_id = $order->get_user_id();
        }

        $data = json_decode('{"term":0,"externalData":"N/A","transactionId":"N/A", "term_dvn":0}');
        if ( isset($_COOKIE['send_pepper_info']) ) {
            $data = json_decode(stripslashes($_COOKIE['send_pepper_info']));
        }

        $term = $product_type == 'STD' ? intval($data->term) : intval($data->term_dvn);

        $products = array();
        $total_products = 0;
        //Fill Products
        foreach ($order->get_items() as $item) {
            $product_reference = '';
            $product_id = '';
            $product_name = '';
            $product_quantity = '';
            $product_price = '';
            $product_reference = '';
            if ( version_compare( WOOCOMMERCE_VERSION, '3.0', '<' ) ) {
                $product_id = $item['product_id'];
                $product_reference = $item['variation_id'];
                $product_name = $item['name'];
                $product_quantity = intval($item['quantity']);
                $product = wc_get_product( $product_id );
                $product_price = $product['price'];
            } else {
                $product_id = $item->get_product_id();
                $product_reference = $item->get_variation_id();
                $product_name = $item->get_name();
                $product_quantity = intval($item->get_quantity());
                $product = wc_get_product( $product_id );
                $product_price = $product->get_price();
            }
            if (!isset($product_reference) || empty($product_reference)) {
                $product_reference = 'YYY';
            }
            $products[] = array(
                'id' => $product_id.'',
                'reference' => $product_reference.'',
                'name' => $product_name,
                'qty' => $product_quantity,
                'price' => round(floatval($product_price), 2),
                'attributes' => null
            );
            $total_products += $product_quantity;
        }


        if (strlen($phone) < 9) {
            $phone = '';
        }

        //check shipping address (if any field is empty returns null).
        $billing_address = array(
            'country' => $country,
            'city' => $city,
            'province' => $state,
            'postal_code' => $postal_code,
            'address' => $line1 . ' ' . $line2,
            'phone' => $phone
        );
        $shipping_address = $this->check_shipping_address($ship_country, $ship_city, $ship_state, $ship_postal_code, $ship_line1, $ship_line2, $phone, $billing_address);

        $json = array(
            'platform' => 'WOO30',
            'order_date' => date('Y-m-d'),
            'transaction_id' => $data->transactionId,
            'term' => intval($term),
            'total_products' => $total_products,
            'total_price' => round(floatval((float)$order->get_total()), 2),
            'process_type' => 'DEFAULT',
            'product_type' => $product_type,
            'cart' =>
                array(
                    'id' => $order_id.'',
                    'cart_price' => round(floatval((float)$order->get_total()), 2),
                    'shipping_price' => round(floatval((float)$order->get_shipping_total()), 2),
                    'products' => $products
                ),
            'applicant' =>
                array(
                    'id' => $user_id.'',
                    'name' => $first_name,
                    'last_name' => $last_name,
                    'email' => $email,
                    'group' => null,
                    'gender' => null,
                    'birthday' => null,    
                    'billing_address' => $billing_address,             
                    'shipping_address' => $shipping_address
                ),
            'url_callback' => $notify_url
        );

        if ($addCartUrl) {
            $json['cart_url'] = wc_get_checkout_url();
        }

        if ($viewMode) {
            $json['view_mode'] = $viewMode;
        }
        return $json;
    }

    private function check_shipping_address($ship_country, $ship_city, $ship_state, $ship_postal_code, $ship_line1, $ship_line2, $phone, $billing_address){
        $isOK = false;
        $shipping_address = $billing_address;
        $ship_lines = $ship_line1.$ship_line2;
        if(isset($ship_country, $ship_city, $ship_state, $ship_postal_code, $ship_lines, $phone)){
            if(!(empty($ship_country)||empty($ship_city)||empty($ship_postal_code)||empty($ship_lines)||empty($phone))){
                $shipping_address = array(
                    'country' => $ship_country,
                    'city' => $ship_city,
                    'province' => $ship_state,
                    'postal_code' => $ship_postal_code,
                    'address' => $ship_line1 . ' ' . $ship_line2,
                    'phone' => $phone
                );
            }
        }

        return $shipping_address;
    }

    private function check_fill_first_last_name(&$first_name, &$last_name){
        if(empty($last_name)){
            $fn_parts = explode(' ', $first_name);
            
            if(count($fn_parts)>1){
                $first_name = array_shift($fn_parts);
                $last_name = implode(' ', $fn_parts);
            }else{
                $first_name = $fn_parts[0];
                $last_name = $first_name;
            }
        }
    }
}

