<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
?>

<script type="text/javascript">
    /**
    * Pepper Module
    *
    * Copyright (c) 2020 Pepper
    *
    * @category  Payment
    * @author    Pepper
    * @copyright 2020, Pepper
    * @link      https://peppermoney.es/
    */

    //Apoyo para trabajo sessionStorage
    function setSessionStoragePepper(key, value) {
        if(typeof(Storage) !== "undefined") {
            sessionStorage.setItem(key, value);
        }
    }
    function getSessionStoragePepper (key) {
        if(typeof(Storage) !== "undefined") {
            return sessionStorage.getItem(key);
        }
        else {
            return null;
        }
    }

    if (typeof PEPPER !== 'object') {
        var PEPPER = {}
    }

    PEPPER.config = {
        config: null,
        environment: null,
        language: null,
        currency: null,
        sessionName: 'pepper_config',
        domain: null,
        domainConfig: null,
        apiKey: null,
        publicKey: null,

        init: async function (environment, language, currency, apiKey, publicKey) {
            this.environment = environment;
            this.domain = (environment == "PRO") ? 'https://api.peppermoney.es' : 'https://play-api.peppermoneytest.es';
			this.domainConfig = (environment == "PRO") ? 'https://merchant-config.pepperfinance.es' : 'https://play-merchant-config.pepperfinance.es';
            this.language = language;
            this.publicKey = publicKey;
            this.apiKey = apiKey;
            this.currency = currency;
            try {
                await this.getConfig();
            } catch (err) {
                console.error(err);
            }
        },
        getConfig: async function() {
            try{
                if (getSessionStoragePepper(this.sessionName) !== null) {
                    this.config = JSON.parse(getSessionStoragePepper(this.sessionName)).data;
                    if (this.config.enabled === true) {
                        await this.injectAssets();
                    }
                }
                else {
                    await this.getConfigAjax()
                    .catch(function(error){
                        console.error(error);
                    });
                }
            }
            catch (err) {
                console.error(err);
            }
        },
        getConfigAjax: async function () {
            var that = this;
            return new Promise(function(resolve, reject) {
                var xmlHttp = new XMLHttpRequest();
                xmlHttp.onreadystatechange = function() {
                    if (xmlHttp.readyState == 4) {
                        var response = JSON.parse(xmlHttp.responseText);
                        if (typeof response == 'object') {
                            if (!response.result.errors) {
                                that.config = response.data;
                                setSessionStoragePepper(that.sessionName, JSON.stringify(response));
                                if (that.config.enabled === true) {
                                    resolve(that.injectAssets());
                                }
                                if (that.config.error) {
                                    reject(that.config.error);
                                }
                            } else {
                                reject (response.result);
                            }
                        }
                    }
                }				
                xmlHttp.onerror = () => reject('Petition error');
                xmlHttp.ontimeout  = () => reject('Timeour error');
                xmlHttp.open('GET', that.domainConfig + '/api/v1/merchants/' + that.publicKey + '/config?language=' + that.language + '&currency=' + that.currency + '&origin=' + encodeURIComponent(location.origin) , true);
                xmlHttp.setRequestHeader("Content-type", "application/json");
                xmlHttp.send();
                
            });
        },
        injectAssets: async function () {
            try {
                this.getCss();
                await this.getJs();
            } catch (err) {
                throw err;
            }
        },
        getCss: function () {
            var url = this.config.css_version;
            var elmt = document.createElement("link");
            elmt.setAttribute('rel', 'stylesheet');
            elmt.setAttribute('type', 'text/css');
            elmt.setAttribute('href', url);

            document.getElementsByTagName("head")[0].appendChild(elmt);
        },
        getJs: async function () {
            var that = this;
            return new Promise(function(resolve, reject) {
                var elmt = document.createElement("script");
                elmt.setAttribute('type', 'text/javascript');
                elmt.setAttribute('src', that.config.js_version);

                var elmt2 = document.createElement("script");
                elmt2.setAttribute('type', 'text/javascript');
                elmt2.setAttribute('src', that.config.js_platform_version);
                
                elmt2.addEventListener('load', function() {
                    try {
                        if (typeof PEPPER === 'object' && typeof PEPPER.widgets === 'object') {
                            PEPPER.widgets.init(
                                that.config, that.domain, that.publicKey, that.apiKey, that.currency
                            );
                        } else {
                            console.error('PEPPER.widgets is not an object');
                        }
                    } catch (err) {
                        console.error(err);
                    }
                });

                var head_element = document.getElementsByTagName("head")[0];
                elmt.addEventListener('load', function() {
                    head_element.appendChild(elmt2);
                });
                head_element.appendChild(elmt);
                resolve();
            });
        }
    };


    let settimeoutId=null;
    document.addEventListener("DOMContentLoaded", function(event) {
        PEPPER.config.init(
            "<?php echo $environment; ?>",
            "ES",
            "EUR",
            "<?php echo $api_key; ?>",
            "<?php echo $public_key; ?>"
        );

        //Show DVN action.
        if (document.querySelector('#payment')) {
            settimeoutId = setTimeout(showPaymentNWithQuotes, 100);
            document.querySelector('#payment').addEventListener('DOMSubtreeModified', paymentDomChanging, false);
        }
    });

    let changing = 0;
    function paymentDomChanging(){
        changing += 1;
    }


    function showPaymentNWithQuotes(){
        clearTimeout(settimeoutId);
        
        //if (document.readyState === "complete" ){
        if (changing == 0 && PEPPER.widgets) {
            let tag = document.querySelector('label[for=payment_method_pepper_n_gateway]');
            if (tag) {
                const spc = sessionStorage.getItem('pepper_config');
                const pc = JSON.parse(spc);
    
                const pc_checkout = pc.data.widget_sections.filter(x=>x.section=='checkout')[0];
    
                const price_tag = document.querySelector(pc_checkout.dom_var_price);
                let amount = parseAmountHelperPepper(price_tag);
                let data_dvn = PEPPER.widgets.getFinancialInfo(amount, null, 'total', 'DVN');
                if (data_dvn.payment && data_dvn.term > 0) {
                    let textChild = tag.firstChild;
                    text = textChild.textContent.replace('{{NumCuotas}}', data_dvn.term);
                    textChild.textContent = text;
                } else {
                    let parent = tag.parentElement;
                    parent.style.display = 'none';
                }
            }
        } else {
            changing -= 1;
            settimeoutId = setTimeout(showPaymentNWithQuotes, 250);
        }
    }

    function parseAmountHelperPepper(amount) {
        var splitAmount = getInnerTextNumberHelperPepper(amount, "0").replace(/[^0-9.,]+/gm, '').split(',');
        var finalAmount = null;
        if (splitAmount[splitAmount.length - 1].indexOf('.') > -1) {
            var decimalAmount = splitAmount[splitAmount.length - 1].split('.');
            splitAmount[splitAmount.length - 1] = decimalAmount[0];
            finalAmount = splitAmount.join('');
            if (decimalAmount.length === 2 && decimalAmount[decimalAmount.length -1].length === 3) {
                finalAmount = decimalAmount.join('')
            }
            else if (decimalAmount.length === 2) {
                finalAmount += '.' + decimalAmount[1];
            }
        } else {
            finalAmount = splitAmount[0].replace('.', '') + '.' + splitAmount[1];
        }
    
        return parseFloat(finalAmount);
    }

    function getInnerTextNumberHelperPepper(elem, defaultValue){
        var result = defaultValue;
        if (elem!==null){
            try {
                if (elem.value){
                    result = elem.value;
                }
                else if (elem.innerText){
                    result = elem.innerText
                }
                else {
                    result = defaultValue;
                }
            } catch (err) {
                result = defaultValue;
            }
        }
        return result;
    }
</script>
