<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

global $product;

if ( function_exists( 'wc_get_price_including_tax' ) ) {
	$price = wc_get_price_including_tax( $product );
} else {
	$price = $product->get_price_including_tax();
}
?>

<div id="pepper-product">
    <div style="display: none" id="pepper-product-price"><?php echo $price; ?></div>
    <div style="display: none" id="pepper-product-qty">1</div>
    <div id="pepper-product-widget"></div>
</div>

<script>
  document.addEventListener("DOMContentLoaded", function(event) {
    var value = 1;
    var element = document.getElementsByName('quantity')[0];
    element.onchange = function() {
      document.getElementById('pepper-product-qty').innerHTML = this.value;
    };
    setInterval(function () {
      if (element.value != value) {
        value = element.value;
        document.getElementById('pepper-product-qty').innerHTML = element.value;
      }
    }, 500);
  });
</script>
